<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="3.0"
    exclude-result-prefixes="xs fn pl">
    
    <xsl:output method="xml" indent="yes" encoding="UTF-8" cdata-section-elements="" />
    
    <xsl:template match="/">
        <example-conditions>
            <!-- 1. If condition -->
            <example-if>
                <xsl:for-each select="/Table/Items/Item">
                    <xsl:if test="not(Classification[@key='typology'])">
                        <xsl:variable name="ean" select="Identifier[@key='ean']" />
                        <unclassified ean="{$ean}" />
                    </xsl:if>
                    <!--
                        Generally you can use the condition in the XPath as a predicate, this is more efficient
                        Here you can remove the if condition, and in for-each select use the XPath:
                        /Table/Items/Item[not(Classification[@key='typology'])]
                    -->
                </xsl:for-each>
            </example-if>

            <!-- 2. Switch case condition -->
            <example-choose>
                <xsl:for-each select="/Table/Items/Item">
                    <xsl:variable name="typolgy" select="Classification[@key='typology']" />
                    <xsl:variable name="ean" select="Identifier[@key='ean']" />
                    <!-- XSL use choose + when + otherwise -->
                    <xsl:choose>
                        <xsl:when test="phone">
                            <phone ean="{$ean}" />
                        </xsl:when>
                        <xsl:when test="dishwasher">
                            <dishwasher ean="{$ean}" />
                        </xsl:when>
                        <xsl:otherwise>
                            <unclassified ean="{$ean}" />
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </example-choose>
        </example-conditions>
    </xsl:template>
</xsl:stylesheet>